package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.EstudioDocOS2Dao;
import com.ejie.ab04b.model.EstudioDocOS2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0446s00ServiceImpl generated by UDA, 14-Feb-2017 10:29:39.
 * 
 * @author UDA
 */

@Service(value = "estudioDocOS2ServiceImpl")
public class EstudioDocOS2ServiceImpl implements EstudioDocOS2Service {

	@Autowired()
	private EstudioDocOS2Dao ab0446s00Dao;

	/**
	 * Inserts a single row in the Ab0446s00 table.
	 * 
	 *  ab0446s00
	 *            Ab0446s00
	 *  Ab0446s00
	 *
	 * @param ab0446s00 the ab 0446 s 00
	 * @return the estudio doc OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstudioDocOS2 add(EstudioDocOS2 ab0446s00) {
		return this.ab0446s00Dao.add(ab0446s00);
	}

	/**
	 * Updates a single row in the Ab0446s00 table.
	 * 
	 *  ab0446s00
	 *            Ab0446s00
	 *  Ab0446s00
	 *
	 * @param ab0446s00 the ab 0446 s 00
	 * @return the estudio doc OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstudioDocOS2 update(EstudioDocOS2 ab0446s00) {
		return this.ab0446s00Dao.update(ab0446s00);
	}

	/**
	 * Finds a single row in the Ab0446s00 table.
	 * 
	 *  ab0446s00
	 *            Ab0446s00
	 *  Ab0446s00
	 *
	 * @param ab0446s00 the ab 0446 s 00
	 * @return the estudio doc OS 2
	 */
	public EstudioDocOS2 find(EstudioDocOS2 ab0446s00) {
		return (EstudioDocOS2) this.ab0446s00Dao.find(ab0446s00);
	}

	/**
	 * Deletes a single row in the Ab0446s00 table.
	 * 
	 *  ab0446s00
	 *            Ab0446s00
	 *
	 * @param ab0446s00 the ab 0446 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EstudioDocOS2 ab0446s00) {
		this.ab0446s00Dao.remove(ab0446s00);
	}

	/**
	 * Finds a list of rows in the Ab0446s00 table.
	 * 
	 *  ab0446s00
	 *            Ab0446s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0446s00>
	 *
	 * @param ab0446s00 the ab 0446 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<EstudioDocOS2> findAll(EstudioDocOS2 ab0446s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<EstudioDocOS2>) this.ab0446s00Dao.findAll(ab0446s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0446s00 table using like.
	 * 
	 *  ab0446s00
	 *            Ab0446s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0446s00>
	 *
	 * @param ab0446s00 the ab 0446 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<EstudioDocOS2> findAllLike(EstudioDocOS2 ab0446s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<EstudioDocOS2>) this.ab0446s00Dao.findAllLike(ab0446s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0446s00 table.
	 * 
	 *  filterAb0446s00
	 *            Ab0446s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0446s00>
	 *
	 * @param filterAb0446s00 the filter ab 0446 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<EstudioDocOS2> filter(
			EstudioDocOS2 filterAb0446s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<EstudioDocOS2> listaAb0446s00 = this.ab0446s00Dao
				.findAllLike(filterAb0446s00, jqGridRequestDto, false);
		Long recordNum = this.ab0446s00Dao.findAllLikeCount(
				filterAb0446s00 != null ? filterAb0446s00 : new EstudioDocOS2(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<EstudioDocOS2>> reorderSelection = this.ab0446s00Dao
					.reorderSelection(filterAb0446s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<EstudioDocOS2>(jqGridRequestDto,
					recordNum, listaAb0446s00, reorderSelection);
		}
		return new JQGridResponseDto<EstudioDocOS2>(jqGridRequestDto, recordNum,
				listaAb0446s00);
	}

	/**
	 * Searches rows in the Ab0446s00 table.
	 * 
	 *  filterAb0446s00
	 *            Ab0446s00
	 *  searchAb0446s00
	 *            Ab0446s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0446s00>>
	 *
	 * @param filterAb0446s00 the filter ab 0446 s 00
	 * @param searchAb0446s00 the search ab 0446 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<EstudioDocOS2>> search(
			EstudioDocOS2 filterAb0446s00, EstudioDocOS2 searchAb0446s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0446s00Dao.search(filterAb0446s00, searchAb0446s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0446s00 table.
	 * 
	 *  filterAb0446s00
	 *            Ab0446s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0446s00 the filter ab 0446 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(EstudioDocOS2 filterAb0446s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0446s00Dao.reorderSelection(filterAb0446s00,
				jqGridRequestDto, startsWith);
	}

}
